#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>

#define MAX_LEN 45

char *bip_strcat_fit(size_t *remaining, char *str, char *str2)
{
	char *res;

	if (!remaining || !str || !str2)
		return NULL;

	res = memccpy(str, str2, '\0', *remaining);
	if (!res)
		return NULL;

	res--;
	if (res < str)
		return NULL;
	(*remaining) -= (size_t)(res - str);
	return res;
}

char *bip_strcatf_fit(size_t *remaining, char *str, char *fmt, ...)
{
	va_list ap;
	char str2[MAX_LEN];
	int written;
	char *res = NULL;

	if (!remaining || !str || !fmt)
		return NULL;

	va_start(ap, fmt);
	written = vsnprintf(str2, *remaining, fmt, ap);
	if (written < 0)
		goto end;

	if ((size_t)written >= *remaining)
		goto end;

	res = memccpy(str, str2, '\0', *remaining);
	if (!res)
		goto end;

	res--;
	if (res < str)
		return NULL;
	(*remaining) -= (size_t)(res - str);

end:
	va_end(ap);
	return res;
}

int main(void)
{
	size_t remaining = MAX_LEN;
	char buf[MAX_LEN+1];
	char *bufpos = buf;

	for (int i=0; i<30; i++) {
		if (i == 0)
			bufpos = bip_strcat_fit(&remaining, bufpos, "test");
		else
			bufpos = bip_strcatf_fit(&remaining, bufpos, " %d", i);
		if (!bufpos) {
			printf("buf is full: %lu/%d\n", strlen(buf), MAX_LEN);
			break;
		}
	}
	printf("%s\n", buf);
	return 0;
}
